(function(){
  function onReady(fn){
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', fn);
    } else {
      fn();
    }
  }

  onReady(function(){
    var search = document.getElementById('gpSearch');
    var filter = document.getElementById('gpFilter');
    var table  = document.getElementById('gpTable');
    var selectAll = document.getElementById('gpSelectAll');

    if (!table || !search) return;

    var rows = Array.prototype.slice.call(table.querySelectorAll('tbody tr'));

    function applyFilter(){
      var q = (search.value || '').toLowerCase().trim();
      var f = filter ? filter.value : 'all';

      rows.forEach(function(row){
        var text = (row.getAttribute('data-text') || '');
        var ok = true;

        if (q && text.indexOf(q) === -1) ok = false;

        if (ok && filter) {
          var upd = row.getAttribute('data-update') === '1';
          var act = row.getAttribute('data-active') === '1';
          if (f === 'updates' && !upd) ok = false;
          if (f === 'active' && !act) ok = false;
          if (f === 'inactive' && act) ok = false;
        }

        if (ok) row.classList.remove('gp-row-hide');
        else row.classList.add('gp-row-hide');
      });
    }

    search.addEventListener('input', applyFilter);
    if (filter) filter.addEventListener('change', applyFilter);

    if (selectAll) {
      selectAll.addEventListener('change', function(){
        var checked = !!this.checked;
        rows.forEach(function(row){
          if (row.classList.contains('gp-row-hide')) return;
          var cb = row.querySelector('input.gp-select');
          if (cb) cb.checked = checked;
        });
      });
    }

    applyFilter();
  });
})();
